/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.controller.pitch;

import com.happysg.radar.block.controller.pitch.AutoPitchControllerBlockEntity;
import com.happysg.radar.block.datalink.DataController;
import com.happysg.radar.block.datalink.DataLinkBlockEntity;
import com.happysg.radar.block.datalink.DataLinkContext;
import com.happysg.radar.block.datalink.DataPeripheral;
import com.happysg.radar.block.datalink.screens.AbstractDataLinkScreen;
import com.happysg.radar.block.datalink.screens.AutoTargetScreen;
import com.happysg.radar.block.datalink.screens.TargetingConfig;
import com.happysg.radar.block.monitor.MonitorBlockEntity;
import com.happysg.radar.block.radar.track.RadarTrack;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class PitchLinkBehavior
extends DataPeripheral {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected AbstractDataLinkScreen getScreen(DataLinkBlockEntity be) {
        return new AutoTargetScreen(be);
    }

    @Override
    protected void transferData(@NotNull DataLinkContext context, @NotNull DataController activeTarget) {
        BlockEntity blockEntity = context.getSourceBlockEntity();
        if (!(blockEntity instanceof AutoPitchControllerBlockEntity)) {
            return;
        }
        AutoPitchControllerBlockEntity controller = (AutoPitchControllerBlockEntity)blockEntity;
        if (context.getMonitorBlockEntity() == null || context.level().m_5776_()) {
            return;
        }
        MonitorBlockEntity monitor = context.getMonitorBlockEntity();
        TargetingConfig targetingConfig = TargetingConfig.fromTag(context.sourceConfig());
        BlockPos mountBlock = controller.getMount();
        Vec3 targetPos = monitor.getTargetPos(targetingConfig);
        RadarTrack track = monitor.getactivetrack();
        monitor.getMount(mountBlock);
        controller.setTrack(track);
        controller.setSafeZones(monitor.safeZones);
        controller.setTarget(targetPos);
        controller.setFiringTarget(targetPos, targetingConfig);
    }
}

